'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Abbruch_Click()
On Error GoTo Err_Abbruch_Click


    DoCmd.Quit

Exit_Abbruch_Click:
    Exit Sub

Err_Abbruch_Click:
    MsgBox err.Description
    Resume Exit_Abbruch_Click
    
End Sub

Public Sub AnzeigeAktualisieren()
    If Fix(Timer) > AktuelleZeit Then                   'Eine Sekunde vergangen?
        'Anzeige aktualisieren
        Select Case DrehZeichen
            Case "|"
                DrehZeichen = "/"
            Case "/"
                DrehZeichen = "-"
            Case "-"
                DrehZeichen = "\"
            Case "\"
                DrehZeichen = "|"
        End Select
        Me.Hinweis.Caption = "Neue Datenfelder werden gefllt. Bitte warten! ....." & DrehZeichen
        Me.Repaint
        AktuelleZeit = Fix(Timer)
    End If
End Sub


Private Sub Button_Test_Click()
On Error GoTo Err_Button_Test_Click
    
    Dim Text As String

    Dim dbs As Database
    Dim tdf As TableDef
    Dim rst As Recordset
    
    Dim sDrive      As String
    Dim sPath       As String
    Dim sFilename   As String
    Dim sExtension  As String
    Dim sSourcePath As String
    
    Dim Quellpfad As String
    Dim i As Long
    Dim DateiSuche As String
    
    If IsNull(Me.Pfadeingabe) Or Trim(Me.Pfadeingabe) = "" Then
        Me.Hinweis.Caption = "Bitte geben Sie Pfad und Dateiname ein."
        Me.Repaint
        Me.Pfadeingabe.SetFocus
        Exit Sub
    End If
    
    Me.VersionAnpassen.Value = False
    Me.DatenkKonvertieren.Value = False
    VersionDatenbankTest = ""
    
    'Pfad in Bestandteile zerlegen
    sDrive = ""
    sPath = ""
    sFilename = ""
    sExtension = ""
    sSourcePath = Trim(Me.Pfadeingabe)
    Call SplitPath(sSourcePath, sDrive, sPath, sFilename, sExtension)
    '  MsgBox Fix(Val(SysCmd(acSysCmdAccessVer)))
    'wenn Pfad ungltig oder Datei nicht gefunden, Hinweis ausgeben
    
    'Datei-Typ
    If (Fix(Val(SysCmd(acSysCmdAccessVer))) < 12) Then
    'bei ACCESS 2000-2003 muss die Endung genau 3 Zeichen lang sein
        If Len(sExtension) <> 3 Then
            Me.Hinweis.Caption = "Der Dateityp muss [MDB] sein."
            Me.Repaint
            Me.Pfadeingabe.SetFocus
            Exit Sub
        Else
            If UCase(sExtension) <> "MDB" Then          'Endung muss genau "MDB" sein
                Me.Hinweis.Caption = "Der Dateityp muss [MDB] sein."
                Me.Repaint
                Me.Pfadeingabe.SetFocus
                Exit Sub
            End If
        End If
    Else
    'bei ACCESS 2007 muss die Endung genau 5 oder 3 Zeichen lang sein
        If (Len(sExtension) <> 5) And (Len(sExtension) <> 3) Then
            Me.Hinweis.Caption = "Der Dateityp muss [ACCDB] oder [MDB] sein."
            Me.Repaint
            Me.Pfadeingabe.SetFocus
            Exit Sub
        Else
            If (UCase(sExtension) <> "ACCDB") And (UCase(sExtension) <> "MDB") Then        'Endung muss genau "ACCDB" oder "MDB" sein
                Me.Hinweis.Caption = "Der Dateityp muss [ACCDB] oder [MDB] sein."
                Me.Repaint
                Me.Pfadeingabe.SetFocus
                Exit Sub
            End If
        End If
    End If
    
    'Datei-Name
    If Len(sFilename) < 1 Then                      'Dateiname muss mindestens 1 Zeichen haben
        Me.Hinweis.Caption = "Der Dateiname muss mindestens ein Zeichen lang sein."
        Me.Repaint
        Me.Pfadeingabe.SetFocus
        Exit Sub
    End If
    
    If (UCase(sExtension) = "ACCDB") Or (UCase(sExtension) = "MDB") Then
        DateiSuche = ""
        On Error Resume Next                    'Meldung "Pfad nicht gefunden" unterdrcken!
        DateiSuche = Dir(sSourcePath)
        On Error GoTo Err_Button_Test_Click     'Fehlerbehandlung wieder einschalten
        If (DateiSuche = "") Then               'Datei auch vorhanden?
            Me.Hinweis.Caption = "Die angegebene Datei wurde nicht gefunden."
            Me.Repaint
            Me.Pfadeingabe.SetFocus
            Exit Sub
        Else
            
            Set dbs = OpenDatabase(sSourcePath)
            
            On Error GoTo Err_FalscheDatenbank     'Bei Tabellenfehler, speziellen Hinweis ausgeben
            Set rst = dbs.OpenRecordset("Einstellungen")
            On Error GoTo Err_Button_Test_Click
            
            'vorhandene Version mit erforderlicher Version prfen
            If rst!DatenbankVersion <> VersionDatenbank Then
                'Prfen, ob Update mglich ist
                
                'Prfen auf ACCESS-Version...
                '...aktuelles Access: bis 2003
                If Fix(Val(SysCmd(acSysCmdAccessVer))) < 12 Then
                    If Right(rst!DatenbankVersion, 4) <> Right(VersionDatenbank, 4) Then
                        Me.Hinweis.Caption = "Die Datei hat die falsche Datenbank-Version."
                        Me.Repaint
                        Me.Pfadeingabe.SetFocus
                        rst.Close
                        dbs.Close
                        Exit Sub
                    End If
                '...aktuelles Access: ab 2007
                Else
                    If Right(rst!DatenbankVersion, 4) <> Right(VersionDatenbank, 4) Then
                        If Right(rst!DatenbankVersion, 4) = "(00)" Then
                            'nur Access 2000 Datenbanken konvertieren
                            Me.DatenkKonvertieren.Value = True
                        Else
                            Me.Hinweis.Caption = "Die Datei hat die falsche Datenbank-Version."
                            Me.Repaint
                            Me.Pfadeingabe.SetFocus
                            rst.Close
                            dbs.Close
                            Exit Sub
                        End If
                    End If
                End If
                
                VersionDatenbankTest = "[" & Left(rst!DatenbankVersion, 10) & "]"
                'Prfen auf Versions-DATUM...
                If InStr(VersionDatenbankAlt, VersionDatenbankTest) > 0 Then
                    Me.Hinweis.Caption = "Datenbank-Version: " & rst!DatenbankVersion & "   >>>  Anpassung notwendig!"
                    Me.Repaint
            '        VersionDatenbankTest = "[" & Left(rst!DatenbankVersion, 10) & "]"
                    Me.Pfadeingabe.Enabled = False
                    Me.Befehl13.Enabled = False             'Button zur Verzeichnisauswahl
                    Me.Button_Uebernehmen.Enabled = True
                    Me.Abbruch.SetFocus
                    ' Me.Button_Uebernehmen.SetFocus
                    Me.Button_Test.Enabled = False
                    If Me.DatenkKonvertieren.Value = False Then
                        Text = "Die ausgewhlte Datei enthllt die Datenbank in einer frheren Version, "
                        Text = Text & "und muss beim ersten ffnen angepasst werden. Die Anpassung kann nicht rckgngig gemacht werden!"
                    Else
                        Text = "Die ausgewhlte Datei enthllt die Datenbank in einer frheren Access-Version, "
                        Text = Text & "und muss in das neue Access-Datenbankformat konvertiert werden. Dieser Vorgang kann nicht rckgngig gemacht werden!"
                    End If
                    Text = Text & vbNewLine & "Es wird dringend empfohlen, vorher eine Sicherungskopie der Datei anzulegen!" & vbNewLine & vbNewLine
                    Text = Text & "Wenn Sie diese Datei JETZT fr die weitere Arbeit anpassen mchten, "
                    Text = Text & "klicken Sie nach dem Schlieen dierser Meldung auf den Haken-Button."
                    Text = Text & vbNewLine & vbNewLine & "Anderenfalls klicken Sie bitte auf STOP."
                    Beep
                    MsgBox Text, vbOKOnly + vbExclamation, "Achtung"
                    'Merker setzen!
                    Me.VersionAnpassen.Value = True
                    rst.Close
                    dbs.Close
                    Exit Sub
                Else
                    If (Fix(Val(SysCmd(acSysCmdAccessVer))) >= 12) And (Me.DatenkKonvertieren.Value = True) Then
                        Me.Hinweis.Caption = "Datenbank-Version: " & rst!DatenbankVersion & "   >>>  Anpassung notwendig!"
                        Me.Repaint
           '             VersionDatenbankTest = "[" & Left(rst!DatenbankVersion, 10) & "]"
                        Me.Pfadeingabe.Enabled = False
                        Me.Befehl13.Enabled = False             'Button zur Verzeichnisauswahl
                        Me.Button_Uebernehmen.Enabled = True
                        Me.Abbruch.SetFocus
                        ' Me.Button_Uebernehmen.SetFocus
                        Me.Button_Test.Enabled = False
                        If Me.DatenkKonvertieren.Value = False Then
                            Text = "Die ausgewhlte Datei enthllt die Datenbank in einer frheren Version, "
                            Text = Text & "und muss beim ersten ffnen angepasst werden. Die Anpassung kann nicht rckgngig gemacht werden!"
                        Else
                            Text = "Die ausgewhlte Datei enthllt die Datenbank in einer frheren Access-Version, "
                            Text = Text & "und muss in das neue Access-Datenbankformat konvertiert werden. Dieser Vorgang kann nicht rckgngig gemacht werden!"
                        End If
                        Text = Text & vbNewLine & "Es wird dringend empfohlen, vorher eine Sicherungskopie der Datei anzulegen!" & vbNewLine & vbNewLine
                        Text = Text & "Wenn Sie diese Datei JETZT fr die weitere Arbeit anpassen mchten, "
                        Text = Text & "klicken Sie nach dem Schlieen dierser Meldung auf den Haken-Button."
                        Text = Text & vbNewLine & vbNewLine & "Anderenfalls klicken Sie bitte auf STOP."
                        Beep
                        MsgBox Text, vbOKOnly + vbExclamation, "Achtung"
                        rst.Close
                        dbs.Close
                        Exit Sub
                    Else
                        'So eine Versionsnummer wurde nie verffentlicht!
                        Me.VersionAnpassen.Value = False
                        Me.DatenkKonvertieren.Value = False
                        Me.Hinweis.Caption = "Die Datei hat eine unbekannte Datenbank-Version."
                        Me.Repaint
                        Me.Pfadeingabe.SetFocus
                        rst.Close
                        dbs.Close
                        Exit Sub
                    End If
                End If
                
            End If
            
            Me.Hinweis.Caption = "Datenbank-Version: " & rst!DatenbankVersion
            Me.Repaint
            rst.Close
            dbs.Close
            
            Me.Pfadeingabe.Enabled = False
            Me.Befehl13.Enabled = False             'Button zur Verzeichnisauswahl
            Me.Button_Uebernehmen.Enabled = True
            Me.Button_Uebernehmen.SetFocus
            Me.Button_Test.Enabled = False
            
        End If
    End If
    
    
Exit_Button_Test_Click:
    Exit Sub
    
Err_Button_Test_Click:
    MsgBox err.Description
    Resume Exit_Button_Test_Click
    
Err_FalscheDatenbank:
    Me.Hinweis.Caption = "Falsche Datenbank."
    Me.Repaint
    Me.Pfadeingabe.SetFocus
    dbs.Close
    Resume Exit_Button_Test_Click

End Sub

Private Sub Button_Uebernehmen_Click()
'    On Error Resume Next        'Fehler ignorieren!
    
    Dim dbs As Database, dbsExterneDB As Database
    Dim tdf As TableDef, tdfExterneDB As TableDef
    Dim rst As Recordset, rst2 As Recordset, rstExterneDB As Recordset
    Dim fld1 As Field, fld2 As Field, fld3 As Field, fld4 As Field, fld5 As Field
    Dim fld6 As Field, fld7 As Field, fld8 As Field, fld9 As Field, fld10 As Field
    Dim idx As Index
    Dim rel As Relation
    Dim WichtigeInfoZumUpdate As String
    Dim Zeichenkette As String
    Dim Meldungstext As String
    Dim FehlerTabelle As String
    Dim FehlerFeld As String
    
    Dim sDrive      As String
    Dim sPath       As String
    Dim sFilename   As String
    Dim sExtension  As String
    Dim sSourcePath As String
    
    Dim Quellpfad As String, Kopiepfad As String, Zielpfad As String
    Dim i As Long
    Dim DateiSuche As String
    
    
    'Merken des angezeigten Textes
    Meldungstext = Me.Hinweis.Caption
    
    
    
    If Me.DatenkKonvertieren.Value = True Then
        ' ===========>>>>>>  Datenbank - Konvertierung !!!!!!!!!!!
        
        'Prfung, ob Dateien mit Namen fr das ZIEL und ZWISCHENKOPIE bereits vorhanden sind
        
        'Pfad in Bestandteile zerlegen
        sDrive = ""
        sPath = ""
        sFilename = ""
        sExtension = ""
        sSourcePath = Trim(Me.Pfadeingabe)
        Call SplitPath(sSourcePath, sDrive, sPath, sFilename, sExtension)
        '  MsgBox sDrive
        '  MsgBox sPath
        '  MsgBox sFilename
        '  MsgBox sExtension
        '  MsgBox sSourcePath
        'wenn Pfad ungltig oder Datei nicht gefunden, Hinweis ausgeben
        
        i = 0
        Zielpfad = sDrive & "\" & sPath & "\" & sFilename & ".accdb"
        DateiSuche = Dir(Zielpfad)
        Do While DateiSuche <> ""
            i = i + 1
            Zielpfad = sDrive & "\" & sPath & "\" & sFilename & "_" & i & ".accdb"
            DateiSuche = Dir(Zielpfad)
        Loop
        
        '....
        Quellpfad = sSourcePath
        'DBEngine.CompactDatabase Quellpfad, Zielpfad, , dbVersion120
        DBEngine.CompactDatabase Quellpfad, Zielpfad, , 128                 'Access 2000:   dbVersion10   (1.0) =   1
                                                                            '               dbVersion11   (1.1) =   8
                                                                            '               dbVersion20   (2.0) =  16
                                                                            '               dbVersion30   (3.0) =  32
                                                                            '               dbVersion40   (4.0) =  64
                                                                            
                                                                            'Access 2007:   dbVersion10   (1.0) =   1
                                                                            '               dbVersion11   (1.1) =   8
                                                                            '               dbVersion20   (2.0) =  16
                                                                            '               dbVersion30   (3.0) =  32
                                                                            '               dbVersion40   (4.0) =  64
                                                                            '               dbVersion120 (12.0) = 128
                                                                            '               dbVersion140 (14.0) = 256
                                                                            
        Me.Pfadeingabe.Value = Zielpfad
                
                
    End If
    
    
    
    If Me.VersionAnpassen.Value = True Then
        Me.Hinweis.Caption = "Anpassung der Datenbank. Bitte warten! ....."
        Me.Repaint
        Me.Abbruch.Enabled = False
        'Me.Button_Uebernehmen.Enabled = False      'deaktiviert, da Element mit Focus nicht deaktiviert werden kann
        
        
        ' EXTERNE Datenbank EXCLUSIV ffnen
        On Error GoTo Error_ExklusivOeffnen
        Set dbsExterneDB = OpenDatabase(Trim(Me.Pfadeingabe), True)
        
        
        
'===>>> Db-Version prfen und eventuell nur Teil-Update!!!
        'ACHTUNG: die neuesten Versionen immer zuerst prfen!!!!!!!
        
        If VersionDatenbankTest = "[2019-03-17]" Then GoTo Struktur_Version_20190317
        If VersionDatenbankTest = "[2016-12-09]" Then GoTo Struktur_Version_20161209
        If VersionDatenbankTest = "[2016-11-05]" Then GoTo Struktur_Version_20161105
        If VersionDatenbankTest = "[2016-10-08]" Then GoTo Struktur_Version_20161008
        If VersionDatenbankTest = "[2016-04-11]" Then GoTo Struktur_Version_20160411
        If VersionDatenbankTest = "[2015-12-22]" Then GoTo Struktur_Version_20151222
        If VersionDatenbankTest = "[2015-12-07]" Then GoTo Struktur_Version_20151207
        If VersionDatenbankTest = "[2015-11-26]" Then GoTo Struktur_Version_20151126
        If VersionDatenbankTest = "[2015-02-07]" Then GoTo Struktur_Version_20150207
        If VersionDatenbankTest = "[2012-04-15]" Then GoTo Struktur_Version_20120415
        If VersionDatenbankTest = "[2011-11-24]" Then GoTo Struktur_Version_20111124
        If VersionDatenbankTest = "[2011-07-06]" Then GoTo Struktur_Version_20110706
        If VersionDatenbankTest = "[2010-01-23]" Then GoTo Struktur_Version_20100123
        If VersionDatenbankTest = "[2009-04-16]" Then GoTo Struktur_Version_20090416
        If VersionDatenbankTest = "[2009-02-02]" Then GoTo Struktur_Version_20090202
        If VersionDatenbankTest = "[2009-01-27]" Then GoTo Struktur_Version_20090127
        If VersionDatenbankTest = "[2009-01-22]" Then GoTo Struktur_Version_20090122
        If VersionDatenbankTest = "[2008-10-30]" Then GoTo Struktur_Version_20081030
        If VersionDatenbankTest = "[2008-05-19]" Then GoTo Struktur_Version_20080519
        
        
        
        
Struktur_Version_20080519:
        'Db-Version [2008-05-19]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "Steuer_ID"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("Steuer_ID", dbText, 50)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20081030:
        'Db-Version [2008-10-30]
        '-----------------------
        ' Tabellen um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "KontoInhaber"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("KontoInhaber", dbText, 50)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_JaNein"
        Set fld1 = tdfExterneDB.CreateField("km_JaNein", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Text"
        Set fld1 = tdfExterneDB.CreateField("km_Text", dbText, 50)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_TabKuerzel"
        Set fld1 = tdfExterneDB.CreateField("km_TabKuerzel", dbText, 5)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_DezTrenner"
        Set fld1 = tdfExterneDB.CreateField("km_DezTrenner", dbText, 15)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Nachkomma"
        Set fld1 = tdfExterneDB.CreateField("km_Nachkomma", dbInteger)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Verwendung"
        Set fld1 = tdfExterneDB.CreateField("km_Verwendung", dbInteger)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Termine"
        FehlerFeld = "km_Anzahl"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine
        Set fld1 = tdfExterneDB.CreateField("km_Anzahl", dbDouble)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Termine_geloescht"
        FehlerFeld = "km_Anzahl"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine_geloescht
        Set fld1 = tdfExterneDB.CreateField("km_Anzahl", dbDouble)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Termine_berechnet"
        FehlerFeld = "km_Netto"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine_berechnet
        Set fld1 = tdfExterneDB.CreateField("km_Netto", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Rechnungsdetails"
        FehlerFeld = "km_Anzahl"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Rechnungsdetails
        Set fld1 = tdfExterneDB.CreateField("km_Anzahl", dbDouble)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Text"
        Set fld1 = tdfExterneDB.CreateField("km_Text", dbText, 50)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Preis"
        Set fld1 = tdfExterneDB.CreateField("km_Preis", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Netto_bisher"
        Set fld1 = tdfExterneDB.CreateField("km_Netto_bisher", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Netto"
        Set fld1 = tdfExterneDB.CreateField("km_Netto", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Einheit"
        Set fld1 = tdfExterneDB.CreateField("km_Einheit", dbText, 5)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "ReTestlauf_Rechnungsdetails"
        FehlerFeld = "km_Anzahl"
        Set tdfExterneDB = dbsExterneDB.TableDefs!ReTestlauf_Rechnungsdetails
        Set fld1 = tdfExterneDB.CreateField("km_Anzahl", dbDouble)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Text"
        Set fld1 = tdfExterneDB.CreateField("km_Text", dbText, 50)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Preis"
        Set fld1 = tdfExterneDB.CreateField("km_Preis", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Netto_bisher"
        Set fld1 = tdfExterneDB.CreateField("km_Netto_bisher", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Netto"
        Set fld1 = tdfExterneDB.CreateField("km_Netto", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "km_Einheit"
        Set fld1 = tdfExterneDB.CreateField("km_Einheit", dbText, 5)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Km_Preise"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Km_Preise")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "gilt_ab"
        Set fld1 = tdf.CreateField("gilt_ab", dbDate)
        'fld1.InputMask = "99.99.00;0;_"
        tdf.Fields.Append fld1
        FehlerFeld = "Preis"
        Set fld1 = tdf.CreateField("Preis", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Jahr"
        Set fld1 = tdf.CreateField("Jahr", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Monat"
        Set fld1 = tdf.CreateField("Monat", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Tag"
        Set fld1 = tdf.CreateField("Tag", dbLong)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Km_Preise
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        
Struktur_Version_20090122:
        'Db-Version [2009-01-22]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "GraueZeile"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("GraueZeile", dbInteger)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "ObenOffset"
        Set fld1 = tdfExterneDB.CreateField("ObenOffset", dbDouble)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "LinksOffset"
        Set fld1 = tdfExterneDB.CreateField("LinksOffset", dbDouble)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "UntenOffset"
        Set fld1 = tdfExterneDB.CreateField("UntenOffset", dbDouble)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "QuerObenOffset"
        Set fld1 = tdfExterneDB.CreateField("QuerObenOffset", dbDouble)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "QuerLinksOffset"
        Set fld1 = tdfExterneDB.CreateField("QuerLinksOffset", dbDouble)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "QuerUntenOffset"
        Set fld1 = tdfExterneDB.CreateField("QuerUntenOffset", dbDouble)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20090127:
        'Db-Version [2009-01-27]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "Rechnungsformular"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("Rechnungsformular", dbInteger)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "Stornoformular"
        Set fld1 = tdfExterneDB.CreateField("Stornoformular", dbInteger)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "Zeitformat"
        Set fld1 = tdfExterneDB.CreateField("Zeitformat", dbInteger)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "FormRechnungen"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("FormRechnungen")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "Formularnummer"
        Set fld1 = tdf.CreateField("Formularnummer", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Ueberschrift"
        Set fld1 = tdf.CreateField("Ueberschrift", dbText, 50)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!FormRechnungen
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "FormStornos"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("FormStornos")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "Formularnummer"
        Set fld1 = tdf.CreateField("Formularnummer", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Ueberschrift"
        Set fld1 = tdf.CreateField("Ueberschrift", dbText, 50)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!FormStornos
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        
Struktur_Version_20090202:
        'Db-Version [2009-02-02]
        '-----------------------
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Einstellungen2"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Einstellungen2")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "BalkenPositiv_R"
        Set fld1 = tdf.CreateField("BalkenPositiv_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "BalkenPositiv_G"
        Set fld1 = tdf.CreateField("BalkenPositiv_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "BalkenPositiv_B"
        Set fld1 = tdf.CreateField("BalkenPositiv_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "BalkenNegativ_R"
        Set fld1 = tdf.CreateField("BalkenNegativ_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "BalkenNegativ_G"
        Set fld1 = tdf.CreateField("BalkenNegativ_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "BalkenNegativ_B"
        Set fld1 = tdf.CreateField("BalkenNegativ_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis1_R"
        Set fld1 = tdf.CreateField("Kreis1_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis1_G"
        Set fld1 = tdf.CreateField("Kreis1_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis1_B"
        Set fld1 = tdf.CreateField("Kreis1_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis2_R"
        Set fld1 = tdf.CreateField("Kreis2_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis2_G"
        Set fld1 = tdf.CreateField("Kreis2_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis2_B"
        Set fld1 = tdf.CreateField("Kreis2_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis3_R"
        Set fld1 = tdf.CreateField("Kreis3_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis3_G"
        Set fld1 = tdf.CreateField("Kreis3_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis3_B"
        Set fld1 = tdf.CreateField("Kreis3_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis4_R"
        Set fld1 = tdf.CreateField("Kreis4_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis4_G"
        Set fld1 = tdf.CreateField("Kreis4_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis4_B"
        Set fld1 = tdf.CreateField("Kreis4_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis5_R"
        Set fld1 = tdf.CreateField("Kreis5_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis5_G"
        Set fld1 = tdf.CreateField("Kreis5_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis5_B"
        Set fld1 = tdf.CreateField("Kreis5_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis6_R"
        Set fld1 = tdf.CreateField("Kreis6_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis6_G"
        Set fld1 = tdf.CreateField("Kreis6_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis6_B"
        Set fld1 = tdf.CreateField("Kreis6_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis7_R"
        Set fld1 = tdf.CreateField("Kreis7_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis7_G"
        Set fld1 = tdf.CreateField("Kreis7_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis7_B"
        Set fld1 = tdf.CreateField("Kreis7_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis8_R"
        Set fld1 = tdf.CreateField("Kreis8_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis8_G"
        Set fld1 = tdf.CreateField("Kreis8_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Kreis8_B"
        Set fld1 = tdf.CreateField("Kreis8_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Bericht_R"
        Set fld1 = tdf.CreateField("Bericht_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Bericht_G"
        Set fld1 = tdf.CreateField("Bericht_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Bericht_B"
        Set fld1 = tdf.CreateField("Bericht_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Rech_R"
        Set fld1 = tdf.CreateField("Rech_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Rech_G"
        Set fld1 = tdf.CreateField("Rech_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Rech_B"
        Set fld1 = tdf.CreateField("Rech_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Storno_R"
        Set fld1 = tdf.CreateField("Storno_R", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Storno_G"
        Set fld1 = tdf.CreateField("Storno_G", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Storno_B"
        Set fld1 = tdf.CreateField("Storno_B", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "KreisProzentRest"
        Set fld1 = tdf.CreateField("KreisProzentRest", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "KreisJaNein"
        Set fld1 = tdf.CreateField("KreisJaNein", dbBoolean)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen2
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        
Struktur_Version_20090416:
        'Db-Version [2009-04-16]
        '-----------------------
        ' Tabellen um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "TerminPrivat"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("TerminPrivat", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "TerminOhneKontakt"
        Set fld1 = tdfExterneDB.CreateField("TerminOhneKontakt", dbText, 5)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Termine"
        FehlerFeld = "Privat"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine
        Set fld1 = tdfExterneDB.CreateField("Privat", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Termine_geloescht"
        FehlerFeld = "Privat"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine_geloescht
        Set fld1 = tdfExterneDB.CreateField("Privat", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20100123:
        'Db-Version [2010-01-23]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "StdSatzNachkomma"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("StdSatzNachkomma", dbInteger)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20110706:
        'Db-Version [2011-07-06]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Aktualisierungen"
        FehlerFeld = "TagVon"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Aktualisierungen
        Set fld1 = tdfExterneDB.CreateField("TagVon", dbText, 10)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "TagBis"
        Set fld1 = tdfExterneDB.CreateField("TagBis", dbText, 10)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20111124:
        'Db-Version [2011-11-24]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Rechnungsdetails"
        FehlerFeld = "Privat"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Rechnungsdetails
        Set fld1 = tdfExterneDB.CreateField("Privat", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "ReTestlauf_Rechnungsdetails"
        FehlerFeld = "Privat"
        Set tdfExterneDB = dbsExterneDB.TableDefs!ReTestlauf_Rechnungsdetails
        Set fld1 = tdfExterneDB.CreateField("Privat", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20120415:
        'Db-Version [2012-04-15]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "PreisJeKategorie_JaNein"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("PreisJeKategorie_JaNein", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Kunden"
        FehlerFeld = "PreisJeKategorie_JaNein"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Kunden
        Set fld1 = tdfExterneDB.CreateField("PreisJeKategorie_JaNein", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Termine"
        FehlerFeld = "lfd_Nr_Kategorie"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Kategorie", dbLong)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "Su_Kalkulation"
        Set fld1 = tdfExterneDB.CreateField("Su_Kalkulation", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Termine_geloescht"
        FehlerFeld = "lfd_Nr_Kategorie"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine_geloescht
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Kategorie", dbLong)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "Su_Kalkulation"
        Set fld1 = tdfExterneDB.CreateField("Su_Kalkulation", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Rechnungen"
        FehlerFeld = "lfd_Nr_Kategorie"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Rechnungen
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Kategorie", dbLong)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "ReTestlauf_Rechnungen"
        FehlerFeld = "lfd_Nr_Kategorie"
        Set tdfExterneDB = dbsExterneDB.TableDefs!ReTestlauf_Rechnungen
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Kategorie", dbLong)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Rechnungslaeufe"
        FehlerFeld = "Kategorie"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Rechnungslaeufe
        Set fld1 = tdfExterneDB.CreateField("Kategorie", dbText, 100)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Kategorien"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Kategorien")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "Kategorie_ID"
        Set fld1 = tdf.CreateField("Kategorie_ID", dbMemo)
        tdf.Fields.Append fld1
        FehlerFeld = "Name1"
        Set fld1 = tdf.CreateField("Name1", dbText, 100)
        tdf.Fields.Append fld1
        FehlerFeld = "FarbNr"
        Set fld1 = tdf.CreateField("FarbNr", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Rot"
        Set fld1 = tdf.CreateField("Rot", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Gruen"
        Set fld1 = tdf.CreateField("Gruen", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Blau"
        Set fld1 = tdf.CreateField("Blau", dbInteger)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Kategorien
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Preise"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Preise")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "lfd_Nr_Kunde"
        Set fld1 = tdf.CreateField("lfd_Nr_Kunde", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "lfd_Nr_Kategorie"
        Set fld1 = tdf.CreateField("lfd_Nr_Kategorie", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "gilt_ab"
        Set fld1 = tdf.CreateField("gilt_ab", dbDate)
        tdf.Fields.Append fld1
        FehlerFeld = "Std_Satz"
        Set fld1 = tdf.CreateField("Std_Satz", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Jahr"
        Set fld1 = tdf.CreateField("Jahr", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Monat"
        Set fld1 = tdf.CreateField("Monat", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Tag"
        Set fld1 = tdf.CreateField("Tag", dbLong)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Preise
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Termine_kalkuliert"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Termine_kalkuliert")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "lfd_Nr_Termin"
        Set fld1 = tdf.CreateField("lfd_Nr_Termin", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Jahr"
        Set fld1 = tdf.CreateField("Jahr", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Monat"
        Set fld1 = tdf.CreateField("Monat", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Netto"
        Set fld1 = tdf.CreateField("Netto", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "km_Netto"
        Set fld1 = tdf.CreateField("km_Netto", dbCurrency)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine_kalkuliert
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        
Struktur_Version_20150207:
        'Db-Version [2015-02-07]
        '-----------------------
        On Error GoTo Error_FelderAnfuegen
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Kalender"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Kalender")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "Aktiv"
        Set fld1 = tdf.CreateField("Aktiv", dbBoolean)
        tdf.Fields.Append fld1
        FehlerFeld = "Name"
        Set fld1 = tdf.CreateField("Name", dbText, 50)
        tdf.Fields.Append fld1
        FehlerFeld = "Kalender_ID"
        Set fld1 = tdf.CreateField("Kalender_ID", dbMemo)
        tdf.Fields.Append fld1
        FehlerFeld = "Store_ID"
        Set fld1 = tdf.CreateField("Store_ID", dbMemo)
        tdf.Fields.Append fld1
        FehlerFeld = "Pfad"
        Set fld1 = tdf.CreateField("Pfad", dbMemo)
        tdf.Fields.Append fld1
        FehlerFeld = "Trennzeichen"
        Set fld1 = tdf.CreateField("Trennzeichen", dbText, 10)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Kalender
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        'Tabelle um neues Feld ergnzen
        FehlerTabelle = "Termine"
        FehlerFeld = "lfd_Nr_Kalender"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Kalender", dbLong)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20151126:
        'Db-Version [2015-11-26]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "PreisJeKalender_JaNein"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("PreisJeKalender_JaNein", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Preise"
        FehlerFeld = "lfd_Nr_Kalender"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Preise
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Kalender", dbLong)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20151207:
        'Db-Version [2015-12-07]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        'ALLE Tabellen-Beziehung lschen(!),
        'damit spter ein leeres Kalender-Raster OHNE Kundenbezug angelegt werden kann mit Nr "-1"
        '  Das Lschen einzelner Beziehungen klappt NICHT zuverlssig!
        dbsExterneDB.Relations.Refresh
        Do While dbsExterneDB.Relations.Count > 0
            For Each rel In dbsExterneDB.Relations
                FehlerFeld = rel.Name       'Namen der Ralation auslesen und damit "initialisieren"(!), damit das Lschen klappt!
                    dbsExterneDB.Relations.Delete rel.Name
            Next rel
            Set rel = Nothing
            dbsExterneDB.Relations.Refresh
        Loop
        'Struktur erweitern
        FehlerTabelle = "Termine_Kalender"
        FehlerFeld = "lfd_Nr_Termin"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine_Kalender
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Termin", dbLong)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        FehlerFeld = "lfd_Nr_Kalender"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine_Kalender
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Kalender", dbLong)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        FehlerFeld = "lfd_Nr_Kategorie"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Termine_Kalender
        Set fld1 = tdfExterneDB.CreateField("lfd_Nr_Kategorie", dbLong)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh


Struktur_Version_20151222:
        'Db-Version [2015-12-22]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen2"
        FehlerFeld = "MatrixKalKatExcel_JN"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen2
        Set fld1 = tdfExterneDB.CreateField("MatrixKalKatExcel_JN", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "MatrixKalKatExcel_Datei"
        Set fld1 = tdfExterneDB.CreateField("MatrixKalKatExcel_Datei", dbMemo)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20160411:
        'Db-Version [2016-04-11]
        '-----------------------
        On Error GoTo Error_FelderAnfuegen
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Einst_Kategorien"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Einst_Kategorien")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "Uebernahme"
        Set fld1 = tdf.CreateField("Uebernahme", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Datei"
        Set fld1 = tdf.CreateField("Datei", dbMemo)
        tdf.Fields.Append fld1
        FehlerFeld = "KategorieWo"
        Set fld1 = tdf.CreateField("KategorieWo", dbText, 3)
        tdf.Fields.Append fld1
        FehlerFeld = "WoVon"
        Set fld1 = tdf.CreateField("WoVon", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "WoBis"
        Set fld1 = tdf.CreateField("WoBis", dbInteger)
        tdf.Fields.Append fld1
        FehlerFeld = "Trennzeichen"
        Set fld1 = tdf.CreateField("Trennzeichen", dbText, 3)
        tdf.Fields.Append fld1
        FehlerFeld = "AutoEinlesen_JN"
        Set fld1 = tdf.CreateField("AutoEinlesen_JN", dbBoolean)
        tdf.Fields.Append fld1
        FehlerFeld = "LeereLoeschen_JN"
        Set fld1 = tdf.CreateField("LeereLoeschen_JN", dbBoolean)
        tdf.Fields.Append fld1
        FehlerFeld = "Anfuehrung"
        Set fld1 = tdf.CreateField("Anfuehrung", dbText, 5)
        tdf.Fields.Append fld1
        FehlerFeld = "StrengePruefung"
        Set fld1 = tdf.CreateField("StrengePruefung", dbBoolean)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einst_Kategorien
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Kategorievorgaben"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Kategorievorgaben")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "Kategorie"
        Set fld1 = tdf.CreateField("Kategorie", dbText, 100)
        tdf.Fields.Append fld1
        FehlerFeld = "Kz"
        Set fld1 = tdf.CreateField("Kz", dbInteger)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Kategorievorgaben
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        
Struktur_Version_20161008:
        'Db-Version [2016-10-08]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "MwSt_Kuerzel"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("MwSt_Kuerzel", dbText, 10)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "MwSt_Prioritaet"
        Set fld1 = tdfExterneDB.CreateField("MwSt_Prioritaet", dbInteger)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Kategorien"
        FehlerFeld = "Preis_indiv"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Kategorien
        Set fld1 = tdfExterneDB.CreateField("Preis_indiv", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "MwSt_indiv"
        Set fld1 = tdfExterneDB.CreateField("MwSt_indiv", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "MwSteuer"
        Set fld1 = tdfExterneDB.CreateField("MwSteuer", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Rechnungen"
        FehlerFeld = "MwSt_Splitting"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Rechnungen
        Set fld1 = tdfExterneDB.CreateField("MwSt_Splitting", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "ReTestlauf_Rechnungen"
        FehlerFeld = "MwSt_Splitting"
        Set tdfExterneDB = dbsExterneDB.TableDefs!ReTestlauf_Rechnungen
        Set fld1 = tdfExterneDB.CreateField("MwSt_Splitting", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "Rechnungsdetails"
        FehlerFeld = "MwSt_Kz"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Rechnungsdetails
        Set fld1 = tdfExterneDB.CreateField("MwSt_Kz", dbText, 3)       ' Kz = Kennzeichen [1,2,3,..] (NICHT Krzel)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "MwSt_Satz"
        Set fld1 = tdfExterneDB.CreateField("MwSt_Satz", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        FehlerTabelle = "ReTestlauf_Rechnungsdetails"
        FehlerFeld = "MwSt_Kz"
        Set tdfExterneDB = dbsExterneDB.TableDefs!ReTestlauf_Rechnungsdetails
        Set fld1 = tdfExterneDB.CreateField("MwSt_Kz", dbText, 3)       ' Kz = Kennzeichen [1,2,3,..] (NICHT Krzel)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "MwSt_Satz"
        Set fld1 = tdfExterneDB.CreateField("MwSt_Satz", dbCurrency)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Rechnungen_MwSt"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Rechnungen_MwSt")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "lfd_Nr_Re"
        Set fld1 = tdf.CreateField("lfd_Nr_Re", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Kz"
        Set fld1 = tdf.CreateField("Kz", dbText, 3)
        tdf.Fields.Append fld1
        FehlerFeld = "Netto"
        Set fld1 = tdf.CreateField("Netto", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Prozent"
        Set fld1 = tdf.CreateField("Prozent", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Steuer"
        Set fld1 = tdf.CreateField("Steuer", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Brutto"
        Set fld1 = tdf.CreateField("Brutto", dbCurrency)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Rechnungen_MwSt
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "ReTestlauf_MwSt"
        FehlerFeld = "lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("ReTestlauf_MwSt")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("lfd_Nr", dbLong)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, LongInteger)
        ' oder?: Set fld1 = tdfExterneDB.CreateField("lfd_Nr", dbGUID, ReplicationID)
        fld1.Attributes = dbAutoIncrField
        tdf.Fields.Append fld1
        FehlerFeld = "lfd_Nr_Re"
        Set fld1 = tdf.CreateField("lfd_Nr_Re", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Kz"
        Set fld1 = tdf.CreateField("Kz", dbText, 3)
        tdf.Fields.Append fld1
        FehlerFeld = "Netto"
        Set fld1 = tdf.CreateField("Netto", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Prozent"
        Set fld1 = tdf.CreateField("Prozent", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Steuer"
        Set fld1 = tdf.CreateField("Steuer", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Brutto"
        Set fld1 = tdf.CreateField("Brutto", dbCurrency)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Index zur Tabellendefinition hinzufgen
        FehlerFeld = "Index: lfd_Nr"
        Set tdfExterneDB = dbsExterneDB.TableDefs!ReTestlauf_MwSt
        Set idx = tdfExterneDB.CreateIndex("PrimaerIndex")
        idx.Fields.Append idx.CreateField("lfd_Nr")
        idx.Primary = True
        idx.Unique = True
        tdfExterneDB.Indexes.Append idx
        dbsExterneDB.TableDefs.Refresh
        
        
Struktur_Version_20161105:
        'Db-Version [2016-11-05]
        '-----------------------
        On Error GoTo Error_FelderAnfuegen
        
        'Achtung: ganz neue Tabelle
        FehlerTabelle = "Mehrfachwahl"
        FehlerFeld = "Tab1_lfd_Nr"
            'Tabellendefinition erstellen
        Set tdf = dbsExterneDB.CreateTableDef("Mehrfachwahl")
            'Tabellenfelder zur Tabellendefinition hinzufgen
        Set fld1 = tdf.CreateField("Tab1_lfd_Nr", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Tab2_lfd_Nr"
        Set fld1 = tdf.CreateField("Tab2_lfd_Nr", dbLong)
        tdf.Fields.Append fld1
        FehlerFeld = "Tab1_Name"
        Set fld1 = tdf.CreateField("Tab1_Name", dbText, 100)
        tdf.Fields.Append fld1
        FehlerFeld = "Tab2_Name"
        Set fld1 = tdf.CreateField("Tab2_Name", dbText, 100)
        tdf.Fields.Append fld1
        FehlerFeld = "Auswahl"
        Set fld1 = tdf.CreateField("Auswahl", dbBoolean)
        tdf.Fields.Append fld1
        FehlerFeld = "Betrag"
        Set fld1 = tdf.CreateField("Betrag", dbCurrency)
        tdf.Fields.Append fld1
        FehlerFeld = "Datum"
        Set fld1 = tdf.CreateField("Datum", dbDate)
        tdf.Fields.Append fld1
        FehlerFeld = "Preis"
        Set fld1 = tdf.CreateField("Preis", dbCurrency)
        tdf.Fields.Append fld1
            'Tabellendefiniton zur Liste der Tabellen dauerhaft hinzufgen
        dbsExterneDB.TableDefs.Append tdf
        dbsExterneDB.TableDefs.Refresh
            'Tabelle bewusst ohne Primrindex mit fortlaufender Nr.
        
        
Struktur_Version_20161209:
        'Db-Version [2016-12-09]
        '-----------------------
        ' Tabelle um NEUE Felder ergnzen
        On Error GoTo Error_FelderAnfuegen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "QR_JaNein"
        Set tdfExterneDB = dbsExterneDB.TableDefs!Einstellungen
        Set fld1 = tdfExterneDB.CreateField("QR_JaNein", dbBoolean)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "QR_Position"
        Set fld1 = tdfExterneDB.CreateField("QR_Position", dbText, 3)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "QR_Zoom"
        Set fld1 = tdfExterneDB.CreateField("QR_Zoom", dbInteger)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "QR_Flaeche"
        Set fld1 = tdfExterneDB.CreateField("QR_Flaeche", dbInteger)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "QR_Versatz"
        Set fld1 = tdfExterneDB.CreateField("QR_Versatz", dbSingle)
        tdfExterneDB.Fields.Append fld1
        FehlerFeld = "QR_Text"
        Set fld1 = tdfExterneDB.CreateField("QR_Text", dbText, 150)
        tdfExterneDB.Fields.Append fld1
        tdfExterneDB.Fields.Refresh
        
        
Struktur_Version_20190317:
        'Db-Version [2019-03-17]
        '-----------------------
        ' Hier nichts zu tun, da nur weiter unten ggf. der Dummy-Eintrag
        ' wieder in die Tabelle Kategorien eingetragen wird.
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        


        
        
        
        
        
        
        
        
        
        
        
        'Datenbank schliessen
        dbsExterneDB.Close
        
        '-------------------------------------------------
        'Standwerte fr NEUE Felder weiter unten eingeben!
        '-------------------------------------------------
    End If
        
    
    On Error Resume Next        'Fehler ignorieren!
    
    Set dbs = CurrentDb
    
    Me.Hinweis.Caption = "Interne Tabellen werden neu verknpft. Bitte warten! ....."
    Me.Repaint
    Me.Abbruch.Enabled = False
    Me.Button_Uebernehmen.Enabled = False
    
    
    On Error Resume Next        'Fehlermeldung bei fehlender interner Tabelle bergehen
    'vorhandene verknpfte Tabellen entfernen
    dbs.TableDefs.Delete "Aktualisierungen"
    dbs.TableDefs.Delete "Briefvorlagen"
    dbs.TableDefs.Delete "Datenbankzuordnungen"
    dbs.TableDefs.Delete "Einst_Kategorien"
    dbs.TableDefs.Delete "Einstellungen"
    dbs.TableDefs.Delete "Einstellungen2"
    dbs.TableDefs.Delete "FormRechnungen"
    dbs.TableDefs.Delete "FormStornos"
    dbs.TableDefs.Delete "Gebuehren"
    dbs.TableDefs.Delete "Gebhren_allg"
    dbs.TableDefs.Delete "Jahre"
    dbs.TableDefs.Delete "Kalender"
    dbs.TableDefs.Delete "Kategorien"
    dbs.TableDefs.Delete "Kategorievorgaben"
    dbs.TableDefs.Delete "Km_Preise"
    dbs.TableDefs.Delete "Kunden"
    dbs.TableDefs.Delete "Mehrfachwahl"
    dbs.TableDefs.Delete "Preise"
    dbs.TableDefs.Delete "Rechnungen"
    dbs.TableDefs.Delete "Rechnungen_MwSt"
    dbs.TableDefs.Delete "Rechnungsdetails"
    dbs.TableDefs.Delete "Rechnungslaeufe"
    dbs.TableDefs.Delete "Rechnungsnummern"
    dbs.TableDefs.Delete "ReTestlauf_MwSt"
    dbs.TableDefs.Delete "ReTestlauf_Rechnungen"
    dbs.TableDefs.Delete "ReTestlauf_Rechnungsdetails"
    dbs.TableDefs.Delete "Sperrzeiten"
    dbs.TableDefs.Delete "Steuersaetze"
    dbs.TableDefs.Delete "Termine"
    dbs.TableDefs.Delete "Termine_berechnet"
    dbs.TableDefs.Delete "Termine_geloescht"
    dbs.TableDefs.Delete "Termine_Kalender"
    dbs.TableDefs.Delete "Termine_kalkuliert"
    
    
    
    'Tabellen nun wieder neu verknpfen
    On Error GoTo Error_TabellenVerknuepfen
    
    FehlerTabelle = "FormRechnungen"
    Set tdf = dbs.CreateTableDef("FormRechnungen")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "FormRechnungen"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "FormStornos"
    Set tdf = dbs.CreateTableDef("FormStornos")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "FormStornos"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Km_Preise"
    Set tdf = dbs.CreateTableDef("Km_Preise")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Km_Preise"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Preise"
    Set tdf = dbs.CreateTableDef("Preise")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Preise"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Datenbankzuordnungen"
    Set tdf = dbs.CreateTableDef("Datenbankzuordnungen")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Datenbankzuordnungen"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Gebhren_allg"
    Set tdf = dbs.CreateTableDef("Gebhren_allg")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Gebhren_allg"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Steuersaetze"
    Set tdf = dbs.CreateTableDef("Steuersaetze")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Steuersaetze"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Aktualisierungen"
    Set tdf = dbs.CreateTableDef("Aktualisierungen")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Aktualisierungen"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Briefvorlagen"
    Set tdf = dbs.CreateTableDef("Briefvorlagen")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Briefvorlagen"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Einst_Kategorien"
    Set tdf = dbs.CreateTableDef("Einst_Kategorien")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Einst_Kategorien"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Einstellungen"
    Set tdf = dbs.CreateTableDef("Einstellungen")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Einstellungen"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Einstellungen2"
    Set tdf = dbs.CreateTableDef("Einstellungen2")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Einstellungen2"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Jahre"
    Set tdf = dbs.CreateTableDef("Jahre")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Jahre"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Kalender"
    Set tdf = dbs.CreateTableDef("Kalender")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Kalender"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Kategorien"
    Set tdf = dbs.CreateTableDef("Kategorien")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Kategorien"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Kategorievorgaben"
    Set tdf = dbs.CreateTableDef("Kategorievorgaben")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Kategorievorgaben"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Rechnungsnummern"
    Set tdf = dbs.CreateTableDef("Rechnungsnummern")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Rechnungsnummern"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Rechnungslaeufe"
    Set tdf = dbs.CreateTableDef("Rechnungslaeufe")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Rechnungslaeufe"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Sperrzeiten"
    Set tdf = dbs.CreateTableDef("Sperrzeiten")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Sperrzeiten"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Kunden"
    Set tdf = dbs.CreateTableDef("Kunden")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Kunden"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Gebuehren"
    Set tdf = dbs.CreateTableDef("Gebuehren")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Gebuehren"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Rechnungen"
    Set tdf = dbs.CreateTableDef("Rechnungen")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Rechnungen"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Rechnungen_MwSt"
    Set tdf = dbs.CreateTableDef("Rechnungen_MwSt")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Rechnungen_MwSt"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Rechnungsdetails"
    Set tdf = dbs.CreateTableDef("Rechnungsdetails")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Rechnungsdetails"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "ReTestlauf_MwSt"
    Set tdf = dbs.CreateTableDef("ReTestlauf_MwSt")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "ReTestlauf_MwSt"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "ReTestlauf_Rechnungen"
    Set tdf = dbs.CreateTableDef("ReTestlauf_Rechnungen")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "ReTestlauf_Rechnungen"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "ReTestlauf_Rechnungsdetails"
    Set tdf = dbs.CreateTableDef("ReTestlauf_Rechnungsdetails")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "ReTestlauf_Rechnungsdetails"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Termine"
    Set tdf = dbs.CreateTableDef("Termine")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Termine"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Termine_berechnet"
    Set tdf = dbs.CreateTableDef("Termine_berechnet")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Termine_berechnet"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Termine_geloescht"
    Set tdf = dbs.CreateTableDef("Termine_geloescht")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Termine_geloescht"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Termine_Kalender"
    Set tdf = dbs.CreateTableDef("Termine_Kalender")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Termine_Kalender"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Termine_kalkuliert"
    Set tdf = dbs.CreateTableDef("Termine_kalkuliert")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Termine_kalkuliert"
    dbs.TableDefs.Append tdf
    
    FehlerTabelle = "Mehrfachwahl"
    Set tdf = dbs.CreateTableDef("Mehrfachwahl")
    Zeichenkette = ";DATABASE=" & Trim(Me.Pfadeingabe)
    tdf.Connect = Zeichenkette
    tdf.SourceTableName = "Mehrfachwahl"
    dbs.TableDefs.Append tdf
    
    
    dbs.TableDefs.Refresh
    
    
    
    
    
    
    
    
    
    
    
    ' NEUE Datenfelder mit Werten vorbelegen !
    '--------------------------------------------------------------
    If Me.VersionAnpassen.Value = True Then
    
        'STANDARDwerte in die neuen Felder eintragen
        '-------------------------------------------
        
        DrehZeichen = "|"
        Me.Hinweis.Caption = "Neue Datenfelder werden gefllt. Bitte warten! ....." & DrehZeichen
        Me.Repaint
        ' 1 Sekunde abziehen, damit die Anzeige zu Beginn garantiert akt. wird
        AktuelleZeit = Fix(Timer) - 1

        
'===>>> Db-Version prfen und evt. Teil-Update!!!
        'ACHTUNG: die neuesten Versionen immer zuerst prfen!!!!!!!
        
        If VersionDatenbankTest = "[2019-03-17]" Then GoTo Fuellen_Version_20190317
        If VersionDatenbankTest = "[2016-12-09]" Then GoTo Fuellen_Version_20161209
        If VersionDatenbankTest = "[2016-11-05]" Then GoTo Fuellen_Version_20161105
        If VersionDatenbankTest = "[2016-10-08]" Then GoTo Fuellen_Version_20161008
        If VersionDatenbankTest = "[2016-04-11]" Then GoTo Fuellen_Version_20160411
        If VersionDatenbankTest = "[2015-12-22]" Then GoTo Fuellen_Version_20151222
        If VersionDatenbankTest = "[2015-12-07]" Then GoTo Fuellen_Version_20151207
        If VersionDatenbankTest = "[2015-11-26]" Then GoTo Fuellen_Version_20151126
        If VersionDatenbankTest = "[2015-02-07]" Then GoTo Fuellen_Version_20150207
        If VersionDatenbankTest = "[2012-04-15]" Then GoTo Fuellen_Version_20120415
        If VersionDatenbankTest = "[2011-11-24]" Then GoTo Fuellen_Version_20111124
        If VersionDatenbankTest = "[2011-07-06]" Then GoTo Fuellen_Version_20110706
        If VersionDatenbankTest = "[2010-01-23]" Then GoTo Fuellen_Version_20100123
        If VersionDatenbankTest = "[2009-04-16]" Then GoTo Fuellen_Version_20090416
        If VersionDatenbankTest = "[2009-02-02]" Then GoTo Fuellen_Version_20090202
        If VersionDatenbankTest = "[2009-01-27]" Then GoTo Fuellen_Version_20090127
        If VersionDatenbankTest = "[2009-01-22]" Then GoTo Fuellen_Version_20090122
        If VersionDatenbankTest = "[2008-10-30]" Then GoTo Fuellen_Version_20081030
        If VersionDatenbankTest = "[2008-05-19]" Then GoTo Fuellen_Version_20080519
        
        
        
        
        
Fuellen_Version_20080519:
        'Db-Version [2008-05-19]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "Steuer_ID"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!Steuer_ID = " "
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20081030:
        'Db-Version [2008-10-30]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "KontoInhaber, km_JaNein, km_Text, km_TabKuerzel, km_DezTrenner, km_Nachkomma, km_Verwendung"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!KontoInhaber = " "
        rst!km_JaNein = False
        rst!km_Text = "Reisekilometer"
        rst!km_TabKuerzel = "km"
        rst!km_DezTrenner = "System"
        rst!km_Nachkomma = "2"
        rst!km_Verwendung = "2"                 ' 2="Rechnung & Statistik"
        rst.Update
        rst.Close
        
        FehlerTabelle = "Termine"
        FehlerFeld = "km_Anzahl"
        Set rst = dbs.OpenRecordset("Termine")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!km_Anzahl = 0
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        FehlerTabelle = "Termine_geloescht"
        FehlerFeld = "km_Anzahl"
        Set rst = dbs.OpenRecordset("Termine_geloescht")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!km_Anzahl = 0
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        FehlerTabelle = "Termine_berechnet"
        FehlerFeld = "km_Netto"
        Set rst = dbs.OpenRecordset("Termine_berechnet")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!km_Netto = 0
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        FehlerTabelle = "Rechnungsdetails"
        FehlerFeld = "km_Anzahl, km_Text, km_Preis, km_Netto_bisher, km_Netto, km_Einheit"
        Set rst = dbs.OpenRecordset("Rechnungsdetails")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!km_Anzahl = 0
                rst!km_Text = " "
                rst!km_Preis = 0
                rst!km_Netto_bisher = 0
                rst!km_Netto = 0
                rst!km_Einheit = " "
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        FehlerTabelle = "ReTestlauf_Rechnungsdetails"
        FehlerFeld = "km_Anzahl, km_Text, km_Preis, km_Netto_bisher, km_Netto, km_Einheit"
        Set rst = dbs.OpenRecordset("ReTestlauf_Rechnungsdetails")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!km_Anzahl = 0
                rst!km_Text = " "
                rst!km_Preis = 0
                rst!km_Netto_bisher = 0
                rst!km_Netto = 0
                rst!km_Einheit = " "
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20090122:
        'Db-Version [2009-01-22]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "GraueZeile, ObenOffset, LinksOffset, UntenOffset, QuerObenOffset, QuerLinksOffset, QuerUntenOffset"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!GraueZeile = 5
        rst!ObenOffset = 0
        rst!LinksOffset = 0
        rst!UntenOffset = 0
        rst!QuerObenOffset = 0
        rst!QuerLinksOffset = 0
        rst!QuerUntenOffset = 0
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        


Fuellen_Version_20090127:
        'Db-Version [2009-01-27]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "Rechnungsformular, Stornoformular, Zeitformat"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!Rechnungsformular = 0
        rst!Stornoformular = 0
        rst!Zeitformat = 4
        rst.Update
        rst.Close
        
        FehlerTabelle = "FormRechnungen"
        FehlerFeld = "Formularnummer, Ueberschrift"
        Set rst = dbs.OpenRecordset("FormRechnungen")
        rst.AddNew
        rst!Formularnummer = 0
        rst!Ueberschrift = "Rechnung"
        rst.Update
        rst.Close
        
        FehlerTabelle = "FormStornos"
        FehlerFeld = "Formularnummer, Ueberschrift"
        Set rst = dbs.OpenRecordset("FormStornos")
        rst.AddNew
        rst!Formularnummer = 0
        rst!Ueberschrift = "STORNO zu Rechnung"
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20090202:
        'Db-Version [2009-02-02]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Einstellungen2"
        FehlerFeld = "BalkenPositiv_R, BalkenPositiv_G, BalkenPositiv_B"
        Set rst = dbs.OpenRecordset("Einstellungen2")
        rst.AddNew                      'Erst neu anlegen...
        rst!BalkenPositiv_R = 0
        rst!BalkenPositiv_G = 0
        rst!BalkenPositiv_B = 0
        rst.Update
        FehlerFeld = "BalkenNegativ_R, BalkenNegativ_G, BalkenNegativ_B"
        rst.MoveFirst
        rst.Edit                        'dann ndern...
        rst!BalkenNegativ_R = 255
        rst!BalkenNegativ_G = 0
        rst!BalkenNegativ_B = 0
        rst.Update
        FehlerFeld = "Kreis1_R, Kreis1_G, Kreis1_B"
        rst.MoveFirst
        rst.Edit
        rst!Kreis1_R = 255
        rst!Kreis1_G = 255
        rst!Kreis1_B = 255
        rst.Update
        FehlerFeld = "Kreis2_R, Kreis2_G, Kreis2_B"
        rst.MoveFirst
        rst.Edit
        rst!Kreis2_R = 223
        rst!Kreis2_G = 223
        rst!Kreis2_B = 223
        rst.Update
        FehlerFeld = "Kreis3_R, Kreis3_G, Kreis3_B"
        rst.MoveFirst
        rst.Edit
        rst!Kreis3_R = 191
        rst!Kreis3_G = 191
        rst!Kreis3_B = 191
        rst.Update
        FehlerFeld = "Kreis4_R, Kreis4_G, Kreis4_B"
        rst.MoveFirst
        rst.Edit
        rst!Kreis4_R = 159
        rst!Kreis4_G = 159
        rst!Kreis4_B = 159
        rst.Update
        FehlerFeld = "Kreis5_R, Kreis5_G, Kreis5_B"
        rst.MoveFirst
        rst.Edit
        rst!Kreis5_R = 127
        rst!Kreis5_G = 127
        rst!Kreis5_B = 127
        rst.Update
        FehlerFeld = "Kreis6_R, Kreis6_G, Kreis6_B"
        rst.MoveFirst
        rst.Edit
        rst!Kreis6_R = 95
        rst!Kreis6_G = 95
        rst!Kreis6_B = 95
        rst.Update
        FehlerFeld = "Kreis7_R, Kreis7_G, Kreis_B"
        rst.MoveFirst
        rst.Edit
        rst!Kreis7_R = 63
        rst!Kreis7_G = 63
        rst!Kreis7_B = 63
        rst.Update
        FehlerFeld = "Kreis8_R, Kreis8_G, Kreis8_B"
        rst.MoveFirst
        rst.Edit
        rst!Kreis8_R = 31
        rst!Kreis8_G = 31
        rst!Kreis8_B = 31
        rst.Update
        FehlerFeld = "Bericht_R, Bericht_G, Bericht_B"
        rst.MoveFirst
        rst.Edit
        rst!Bericht_R = 0
        rst!Bericht_G = 0
        rst!Bericht_B = 0
        rst.Update
        FehlerFeld = "Rech_R, Rech_G, Rech_B"
        rst.MoveFirst
        rst.Edit
        rst!Rech_R = 0
        rst!Rech_G = 0
        rst!Rech_B = 0
        rst.Update
        FehlerFeld = "Storno_R, Storno_G, Storno_B"
        rst.MoveFirst
        rst.Edit
        rst!Storno_R = 0
        rst!Storno_G = 0
        rst!Storno_B = 0
        rst.Update
        FehlerFeld = "KreisJaNein, KreisProzentRest"
        rst.MoveFirst
        rst.Edit
        rst!KreisJaNein = True
        rst!KreisProzentRest = 5
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20090416:
        'Db-Version [2009-04-16]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "TerminPrivat, TerminOhneKontakt"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!TerminPrivat = False
        rst!TerminOhneKontakt = "F"
        rst.Update
        rst.Close
        
        FehlerTabelle = "Termine"
        FehlerFeld = "Privat"
        Set rst = dbs.OpenRecordset("Termine")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!Privat = False
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        FehlerTabelle = "Termine_geloescht"
        FehlerFeld = "Privat"
        Set rst = dbs.OpenRecordset("Termine_geloescht")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!Privat = False
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20100123:
        'Db-Version [2010-01-23]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "StdSatzNachkomma"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!StdSatzNachkomma = 4
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20110706:
        'Db-Version [2011-07-06]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Aktualisierungen"
        FehlerFeld = "TagVon, TagBis"
        Set rst = dbs.OpenRecordset("Aktualisierungen")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!TagVon = "01.01."
                'Ermittlung des letzten Tag des Monats durch RELATIVE Datumsangabe in DateSerial!
                'Eingetragener Monat +1 und der 1. (des Folgemonats) -1
                'Bei dieser Funktion wird automatisch ein Jahreswechsel vom System bercksichtig - genial!
                'und Extrahierung von Tag und Monat als Text
                rst!TagBis = Format(Day(DateSerial(rst!Jahr, rst!Monat + 1, 1 - 1)), "00") & "." & _
                             Format(Month(DateSerial(rst!Jahr, rst!Monat + 1, 1 - 1)), "00") & "."
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20111124:
        'Db-Version [2011-11-24]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Rechnungsdetails"
        FehlerFeld = "Privat"
        Set rst = dbs.OpenRecordset("Rechnungsdetails")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!Privat = False
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        FehlerTabelle = "ReTestlauf_Rechnungsdetails"
        FehlerFeld = "Privat"
        Set rst = dbs.OpenRecordset("ReTestlauf_Rechnungsdetails")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!Privat = False
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        '========= nur fr die "echten" Rechnungsdetails ==========
        'eventuell vorhandene Stati bertragen
        'erst die gelschten Termine durchgehen...
        Zeichenkette = "SELECT * FROM Termine_geloescht WHERE ([Privat] = True)"
        Set rst = dbs.OpenRecordset(Zeichenkette)
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                Zeichenkette = "SELECT * FROM Rechnungsdetails WHERE ([Termin_ID] = '" & rst!Termin_ID & "')"
                Set rst2 = dbs.OpenRecordset(Zeichenkette)
                If rst2.RecordCount <> 0 Then
                    rst2.MoveLast                        'Recordset-Objekt auffllen
                    rst2.MoveFirst
                    Do While Not rst2.EOF
                        rst2.Edit
                        rst2!Privat = rst!Privat
                        rst2.Update
                        rst2.MoveNext
                        AnzeigeAktualisieren
                    Loop
                End If
                rst2.Close
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        'eventuell vorhandene Stati bertragen
        'dann die gltigen Termine durchgehen...
        '(um event. neueren Status zu bernehmen)
        Zeichenkette = "SELECT * FROM Termine WHERE ([Privat] = True)"
        Set rst = dbs.OpenRecordset(Zeichenkette)
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                Zeichenkette = "SELECT * FROM Rechnungsdetails WHERE ([Termin_ID] = '" & rst!Termin_ID & "')"
                Set rst2 = dbs.OpenRecordset(Zeichenkette)
                If rst2.RecordCount <> 0 Then
                    rst2.MoveLast                        'Recordset-Objekt auffllen
                    rst2.MoveFirst
                    Do While Not rst2.EOF
                        rst2.Edit
                        rst2!Privat = rst!Privat
                        rst2.Update
                        rst2.MoveNext
                        AnzeigeAktualisieren
                    Loop
                End If
                rst2.Close
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20120415:
        'Db-Version [2012-04-15]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        'Festlegung fr Verwendung der allgemeinen Preistabelle
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "PreisJeKategorie_JaNein"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.MoveFirst
        rst.Edit
        rst!PreisJeKategorie_JaNein = False
        rst.Update
        rst.Close
        
        'Dummy fr Kunden anlegen
        FehlerTabelle = "Kunden"
        FehlerFeld = "Kunden_ID, Name1"
        Set rst = dbs.OpenRecordset("Kunden")
        rst.AddNew
        rst!Kunden_ID = "0123456789DUMMY9876543210"
        rst!Name1 = "(ohne Kontakt)"
        rst.Update
        rst.Close
        
        'Dummy fr Kategorien anlegen
        FehlerTabelle = "Kategorien"
        FehlerFeld = "Kategorie_ID, Name, FarbNr, Rot, Gruen, Blau"
        Set rst = dbs.OpenRecordset("Kategorien")
        rst.AddNew
        rst!Kategorie_ID = "0123456789DUMMY9876543210"
        rst!Name1 = "(ohne Kategorie)"
        rst!FarbNr = 9999                   'wird hoffentlich nie von MS vergeben
        rst!Rot = 255                       ' R,G,B = 255 = wei
        rst!Gruen = 255
        rst!Blau = 255
        rst.Update
        rst.Close
        
        Zeichenkette = "SELECT * FROM Kategorien WHERE ([Kategorie_ID] = '0123456789DUMMY9876543210')"
        Set rst = dbs.OpenRecordset(Zeichenkette)
        SatzKategorieDummy = rst!lfd_Nr
        rst.Close
        
        Zeichenkette = "SELECT * FROM Kunden WHERE ([Kunden_ID] = '0123456789DUMMY9876543210')"
        Set rst = dbs.OpenRecordset(Zeichenkette)
        SatzKontaktDummy = rst!lfd_Nr
        rst.Close
        
        
        'Neues Feld in allen Terminen mit '(ohne Kategorie)' (= Dummy) vorbelegen
        ' und gleich das Feld Kalkulation mit 0 vorbelegen
        FehlerTabelle = "Termine"
        FehlerFeld = "lfd_Nr_Kategorie"
        Set rst = dbs.OpenRecordset("Termine")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!lfd_Nr_Kategorie = SatzKategorieDummy
                rst!Su_Kalkulation = 0
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        'Neues Feld in allen gelschten Terminen mit '(ohne Kategorie)' (= Dummy) vorbelegen
        FehlerTabelle = "Termine_geloescht"
        FehlerFeld = "lfd_Nr_Kategorie"
        Set rst = dbs.OpenRecordset("Termine_geloescht")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!lfd_Nr_Kategorie = SatzKategorieDummy
                rst!Su_Kalkulation = 0
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        'Neues Feld in allen Kunden vorbelegen
        FehlerTabelle = "Kunden"
        FehlerFeld = "PreisJeKategorie_JaNein"
        Set rst = dbs.OpenRecordset("Kunden")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!PreisJeKategorie_JaNein = False
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        'Allgemeine Ghrentabelle in die Tabelle 'Preise' bernehmen,
        'da knftig nur noch diese genutzt wird
        'die neuen Felder fr Kategorie- und Kontakt-Verknpfung mit Link zun den Dummys fllen
        FehlerTabelle = "Preise"
        FehlerFeld = "alle aus Gebhren_allg"
        Set rst = dbs.OpenRecordset("Gebhren_allg")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Set rst2 = dbs.OpenRecordset("Preise")
            Do While Not rst.EOF
                rst2.AddNew
                rst2!lfd_Nr_Kunde = SatzKontaktDummy
                rst2!lfd_Nr_Kategorie = SatzKategorieDummy
                rst2!gilt_ab = rst!gilt_ab
                rst2!Std_Satz = rst!Std_Satz
                rst2!Jahr = rst!Jahr
                rst2!Monat = rst!Monat
                rst2!Tag = rst!Tag
                rst2.Update
                'nchste allgemeine Gebhr
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
            rst2.Close
        End If
        rst.Close
        
        'Kunden-spezifische Ghrentabelle in die Tabelle 'Preise' bernehmen,
        'da knftig nur noch diese genutzt wird
        'mit Link zur Dummy-Kategorie
        FehlerTabelle = "Preise"
        FehlerFeld = "alle aus Gebuehren"
        Set rst = dbs.OpenRecordset("Gebuehren")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Set rst2 = dbs.OpenRecordset("Preise")
            Do While Not rst.EOF
                rst2.AddNew
                rst2!lfd_Nr_Kunde = rst!lfd_Nr_Kunde        ' Kundenzuordnung bernehmen
                rst2!lfd_Nr_Kategorie = SatzKategorieDummy
                rst2!gilt_ab = rst!gilt_ab
                rst2!Std_Satz = rst!Std_Satz
                rst2!Jahr = rst!Jahr
                rst2!Monat = rst!Monat
                rst2!Tag = rst!Tag
                rst2.Update
                'nchste allgemeine Gebhr
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
            rst2.Close
        End If
        rst.Close
        
        'Neues Feld mit '(ohne Kategorie)' (= Dummy) vorbelegen
        FehlerTabelle = "Rechnungen"
        FehlerFeld = "lfd_Nr_Kategorie"
        Set rst = dbs.OpenRecordset("Rechnungen")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!lfd_Nr_Kategorie = SatzKategorieDummy
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        'Neues Feld mit '(ohne Kategorie)' (= Dummy) vorbelegen
        FehlerTabelle = "ReTestlauf_Rechnungen"
        FehlerFeld = "lfd_Nr_Kategorie"
        Set rst = dbs.OpenRecordset("ReTestlauf_Rechnungen")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!lfd_Nr_Kategorie = SatzKategorieDummy
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        'Neues Feld mit 'alle' vorbelegen, da bisher ja keine Wahlmglichkeit war
        FehlerTabelle = "Rechnungslaeufe"
        FehlerFeld = "Kategorie"
        Set rst = dbs.OpenRecordset("Rechnungslaeufe")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!Kategorie = "alle"
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20150207:
        'Db-Version [2015-02-07]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        If Len(WichtigeInfoZumUpdate) = 0 Then
            WichtigeInfoZumUpdate = "NEU: Die Terminabrechnung kann nun mehrere Kalender verarbeiten. Bitte hinterlegen Sie diese in den Einstellungen."
        Else
            WichtigeInfoZumUpdate = WichtigeInfoZumUpdate & vbNewLine & vbNewLine & "Die Terminabrechnung kann nun mehrere Kalender verarbeiten. Bitte hinterlegen Sie diese in den Einstellungen."
        End If

        'Neues Feld mit "-1" fr "Kalender(Ordner)nummer" vorbelegen
        '(nicht "0", da dies in der Preistabelle das Kennzeichen fr "allgemeine" Preise ist, wenn
        'nicht kalenderbezogene Preise berechnet werden sollen)
        FehlerTabelle = "Termine"
        FehlerFeld = "lfd_Nr_Kalender"
        Set rst = dbs.OpenRecordset("Termine")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!lfd_Nr_Kalender = -1
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20151126:
        'Db-Version [2015-02-07]
        '-----------------------
        On Error GoTo Error_FelderFuellen

        'Neues Feld mit "0" fr "Kalender(Ordner)nummer" vorbelegen
        ' 0 = Nummer fr Preise, ohne direkten Kalenderbezug
        FehlerTabelle = "Preise"
        FehlerFeld = "lfd_Nr_Kalender"
        Set rst = dbs.OpenRecordset("Preise")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!lfd_Nr_Kalender = 0
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        'Neues Feld mit "Nein" vorbelegen
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "PreisJeKalender_JaNein"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!PreisJeKalender_JaNein = False
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20151207:
        'Db-Version [2015-12-07]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        'alle alten Datenstze lschen
        FehlerTabelle = "Termine_Kalender"
        FehlerFeld = "<alte Datenstze lschen (ext.DB)>"
        Set rst = dbs.OpenRecordset("Termine_Kalender")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Delete
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        'einmalig leeren "Hintergrund"-Kalender fr die Monate "Jan" bis "Dez" anlegen
        FehlerTabelle = "Termine_Kalender"
        FehlerFeld = "<leeren Kalender anlegen>"
        Set rst = dbs.OpenRecordset("Termine_Kalender")
        For i = 1 To 12
            rst.AddNew
                rst!lfd_Nr_Termin = -1
                rst!lfd_Nr_Kunde = -1
                rst!lfd_Nr_Kalender = -1
                rst!lfd_Nr_Kategorie = -1
                rst!Jahr = -1
                rst!Monat_Nr = i
                Select Case i
                    Case 1
                        rst!Monat = "Jan"
                    Case 2
                        rst!Monat = "Feb"
                    Case 3
                        rst!Monat = "Mrz"
                    Case 4
                        rst!Monat = "Apr"
                    Case 5
                        rst!Monat = "Mai"
                    Case 6
                        rst!Monat = "Jun"
                    Case 7
                        rst!Monat = "Jul"
                    Case 8
                        rst!Monat = "Aug"
                    Case 9
                        rst!Monat = "Sep"
                    Case 10
                        rst!Monat = "Okt"
                    Case 11
                        rst!Monat = "Nov"
                    Case 12
                        rst!Monat = "Dez"
                End Select
                rst!T01 = False
                rst!T02 = False
                rst!T03 = False
                rst!T04 = False
                rst!T05 = False
                rst!T06 = False
                rst!T07 = False
                rst!T08 = False
                rst!T09 = False
                rst!T10 = False
                rst!T11 = False
                rst!T12 = False
                rst!T13 = False
                rst!T14 = False
                rst!T15 = False
                rst!T16 = False
                rst!T17 = False
                rst!T18 = False
                rst!T19 = False
                rst!T20 = False
                rst!T21 = False
                rst!T22 = False
                rst!T23 = False
                rst!T24 = False
                rst!T25 = False
                rst!T26 = False
                rst!T27 = False
                rst!T28 = False
                rst!T29 = False
                rst!T30 = False
                rst!T31 = False
            rst.Update
            AnzeigeAktualisieren
        Next
        rst.Close
        
        ' Es wird immer fr den GESAMTEN Zeitraum eines Termines das Kalenderraster erstellt !
        '=====================================================================================
        ' hnliche Routine auch in der Terminverarbeitung von Outlook-bernahme!
        
        FehlerFeld = "<Neues Kalender-Raster aller Termine>"
        Set rstTermine = dbs.OpenRecordset("SELECT * FROM Termine")
        If rstTermine.RecordCount > 0 Then
            rstTermine.MoveLast         'auffllen
            rstTermine.MoveFirst
            Do While Not rstTermine.EOF
                'Startdatum kopieren, da dies bis zum Endedatum hochgezhlt wird
                KalenderDatum = Format(rstTermine!S_Tag, "00") & "." & Format(rstTermine!S_Monat, "00") & "." & Format(rstTermine!S_Jahr, "0000")
                'Datei fr Kalender-Raster ffnen
                Set rstKalender = dbs.OpenRecordset("SELECT * FROM Termine_Kalender")
                If (rstKalender.RecordCount <> 0) Then rstKalender.MoveLast
                Do While KalenderDatum <= rstTermine!Ende
                    'neuen Eintrag fr Jahr/Monat anlegen
                    rstKalender.AddNew
                        rstKalender!lfd_Nr_Termin = rstTermine!lfd_Nr
                        rstKalender!lfd_Nr_Kunde = rstTermine!lfd_Nr_Kunde
                        rstKalender!lfd_Nr_Kalender = rstTermine!lfd_Nr_Kalender
                        rstKalender!lfd_Nr_Kategorie = rstTermine!lfd_Nr_Kategorie
                        rstKalender!Jahr = Year(KalenderDatum)
                        rstKalender!Monat_Nr = Month(KalenderDatum)
                        Select Case Month(KalenderDatum)
                            Case 1
                                rstKalender!Monat = "Jan"
                            Case 2
                                rstKalender!Monat = "Feb"
                            Case 3
                                rstKalender!Monat = "Mrz"
                            Case 4
                                rstKalender!Monat = "Apr"
                            Case 5
                                rstKalender!Monat = "Mai"
                            Case 6
                                rstKalender!Monat = "Jun"
                            Case 7
                                rstKalender!Monat = "Jul"
                            Case 8
                                rstKalender!Monat = "Aug"
                            Case 9
                                rstKalender!Monat = "Sep"
                            Case 10
                                rstKalender!Monat = "Okt"
                            Case 11
                                rstKalender!Monat = "Nov"
                            Case 12
                                rstKalender!Monat = "Dez"
                        End Select
                        rstKalender!T01 = False
                        rstKalender!T02 = False
                        rstKalender!T03 = False
                        rstKalender!T04 = False
                        rstKalender!T05 = False
                        rstKalender!T06 = False
                        rstKalender!T07 = False
                        rstKalender!T08 = False
                        rstKalender!T09 = False
                        rstKalender!T10 = False
                        rstKalender!T11 = False
                        rstKalender!T12 = False
                        rstKalender!T13 = False
                        rstKalender!T14 = False
                        rstKalender!T15 = False
                        rstKalender!T16 = False
                        rstKalender!T17 = False
                        rstKalender!T18 = False
                        rstKalender!T19 = False
                        rstKalender!T20 = False
                        rstKalender!T21 = False
                        rstKalender!T22 = False
                        rstKalender!T23 = False
                        rstKalender!T24 = False
                        rstKalender!T25 = False
                        rstKalender!T26 = False
                        rstKalender!T27 = False
                        rstKalender!T28 = False
                        rstKalender!T29 = False
                        rstKalender!T30 = False
                        rstKalender!T31 = False
                    rstKalender.Update
                    'letzten bearbeiteten Eintrag zum Aktuellen machen
                    rstKalender.Bookmark = rstKalender.LastModified
                    
                    KalenderMonat = Month(KalenderDatum)
                    Do While ((Month(KalenderDatum) = KalenderMonat) And (KalenderDatum <= rstTermine!Ende))
                        'aktuellen Monat evt. durchgehen, falls Termin ber mehrere Tage (maximal bis Monatsende oder Terminende)
                        If (KalenderDatum = rstTermine!Ende) And (rstTermine!E_Stunde = 0) And (rstTermine!E_Minute = 0) Then
                            'bei Ganztags-Terminen: 00:00 Uhr des letzten Tages abfangen!
                            '(kein Hkchen setzen)
                        Else
                            rstKalender.Edit
                            Select Case Day(KalenderDatum)
                                Case 1
                                    rstKalender!T01 = True
                                Case 2
                                    rstKalender!T02 = True
                                Case 3
                                    rstKalender!T03 = True
                                Case 4
                                    rstKalender!T04 = True
                                Case 5
                                    rstKalender!T05 = True
                                Case 6
                                    rstKalender!T06 = True
                                Case 7
                                    rstKalender!T07 = True
                                Case 8
                                    rstKalender!T08 = True
                                Case 9
                                    rstKalender!T09 = True
                                Case 10
                                    rstKalender!T10 = True
                                Case 11
                                    rstKalender!T11 = True
                                Case 12
                                    rstKalender!T12 = True
                                Case 13
                                    rstKalender!T13 = True
                                Case 14
                                    rstKalender!T14 = True
                                Case 15
                                    rstKalender!T15 = True
                                Case 16
                                    rstKalender!T16 = True
                                Case 17
                                    rstKalender!T17 = True
                                Case 18
                                    rstKalender!T18 = True
                                Case 19
                                    rstKalender!T19 = True
                                Case 20
                                    rstKalender!T20 = True
                                Case 21
                                    rstKalender!T21 = True
                                Case 22
                                    rstKalender!T22 = True
                                Case 23
                                    rstKalender!T23 = True
                                Case 24
                                    rstKalender!T24 = True
                                Case 25
                                    rstKalender!T25 = True
                                Case 26
                                    rstKalender!T26 = True
                                Case 27
                                    rstKalender!T27 = True
                                Case 28
                                    rstKalender!T28 = True
                                Case 29
                                    rstKalender!T29 = True
                                Case 30
                                    rstKalender!T30 = True
                                Case 31
                                    rstKalender!T31 = True
                            End Select
                            rstKalender.Update
                            'letzten bearbeiteten Eintrag zum Aktuellen machen
                            rstKalender.Bookmark = rstKalender.LastModified
                        End If
                        KalenderDatum = KalenderDatum + 1
                        AnzeigeAktualisieren
                    Loop
                    AnzeigeAktualisieren
                Loop
                rstKalender.Close
                'nchsten Termin holen
                rstTermine.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rstTermine.Close
        
        AnzeigeAktualisieren

        
        
Fuellen_Version_20151222:
        'Db-Version [2015-12-22]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        'Neue Felder mit vorbelegen
        FehlerTabelle = "Einstellungen2"
        FehlerFeld = "MatrixKalKatExcel_JN, MatrixKalKatExcel_Datei"
        Set rst = dbs.OpenRecordset("Einstellungen2")
        rst.Edit
        rst!MatrixKalKatExcel_JN = True         'Ja = in Access 2007/2010 statt Exel-Datei das Matrix-Formular ffnen
        rst!MatrixKalKatExcel_Datei = "Termine_Matrix_Kalender-Kategorie.xlsm"
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20160411:
        'Db-Version [2016-04-11]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        'Neue Felder mit vorbelegen
        FehlerTabelle = "Einst_Kategorien"
        FehlerFeld = "<Standardwerte in neuer Tabelle>"
        Set rst = dbs.OpenRecordset("Einst_Kategorien")
        rst.AddNew
        rst!Uebernahme = 0              ' 0 = Alle Kategorien
                                        ' 1 = nur die Kategorien der Vorgabeliste
        rst!Datei = " "
        rst!KategorieWo = "P"           ' [D]atenfeld oder an fester
                                        ' [P]osition (absolute Zeichenpositon)
        rst!WoVon = 0
        rst!WoBis = 0
        rst!Trennzeichen = ";"          ' [;] Standard fr Semikolon-separierte Datenfelder
        rst!AutoEinlesen_JN = False     ' Kategorievorgabeliste vor der Outlookbernahme nicht
                                        ' automatisch aus Datei aktualisieren
        rst!LeereLoeschen_JN = False
        rst!Anfuehrung = "keine"
        rst!StrengePruefung = False     ' Strenge Prfung wre:
                                        ' beim Termin gefundene aber nicht in der Vorgabeliste enthaltene
                                        ' Kategorie wir durch "(ohne Kategorie)" erstzt!
                                        ' Keine Strenge Prfung:
                                        ' beim Termin eingetragene unbekannte Kategorie wird in TA angelegt
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20161008:
        'Db-Version [2016-10-08]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "MwSt_Kuerzel, MwSt_Prioritaet"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!MwSt_Kuerzel = "MwSt"
        rst!MwSt_Prioritaet = 0         ' 0 = Kunde     (vor Kategorie  (vor zentr. MwSt))
                                        ' 1 = Kategorie (vor Kunde      (vor zentr. MwSt))
        rst.Update
        rst.Close
        
        AnzeigeAktualisieren
        
        'Rechnungen um MwSt-Splitting = False ergnzen
        'Rechnungsdetails um MwSt-Satz und -Kennzeichen ergnzen
        FehlerFeld = "<MwSt-Splitting fr bisherige Rechnungen>"
        Set rst = dbs.OpenRecordset("SELECT * FROM Rechnungen")
        If rst.RecordCount > 0 Then
            rst.MoveLast         'auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                Zeichenkette = "SELECT * FROM Rechnungsdetails WHERE ([lfd_Nr_Re] = " & rst!lfd_Nr & ")"
                Set rst2 = dbs.OpenRecordset(Zeichenkette)
                If rst2.RecordCount <> 0 Then
                    rst2.MoveLast                       'Recordset-Objekt auffllen
                    rst2.MoveFirst
                    Do While Not rst2.EOF
                        rst2.Edit
                        rst2!MwSt_Kz = "1"              ' Kz = "Kennzeichen" [1,2,3,..] (NICHT "Krzel")
                                                        ' bisher gab es nur 1 (eine) MwSt je Rechnung
                        rst2!MwSt_Satz = rst!MwSt_Satz  'Steuersatz aus Rechnung bernehmen
                        rst2.Update
                        rst2.MoveNext
                        AnzeigeAktualisieren
                    Loop
                End If
                rst2.Close
                rst.Edit
                rst!MwSt_Splitting = False
                rst.Update
                'nchster Datensatz
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        'Neue Felder in allen Kategorien vorbelegen
        FehlerTabelle = "Kategorien"
        FehlerFeld = "Preis_indiv, MwSt_indiv, MwSteuer"
        Set rst = dbs.OpenRecordset("Kategorien")
        If rst.RecordCount <> 0 Then
            rst.MoveLast                        'Recordset-Objekt auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                rst.Edit
                rst!Preis_indiv = False         'Prophylaktisch schon mal angelegt, aber noch nicht genutzt
                rst!MwSt_indiv = False
                rst!MwSteuer = 0
                rst.Update
                rst.MoveNext
                AnzeigeAktualisieren
            Loop
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20161105:
        'Db-Version [2016-11-05]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        FehlerTabelle = "Mehrfachwahl"
        FehlerFeld = "<nichts zu tun>"
        
        'Die neue Tabelle "Mehrfachwahl" bleibt leer.
        
        AnzeigeAktualisieren
        
        
        
Fuellen_Version_20161209:
        'Db-Version [2016-12-09]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        'Standardvorgaben fr QR-Code auf Rechnungen
        FehlerTabelle = "Einstellungen"
        FehlerFeld = "QR_JaNein, QR_Position, QR_Zoom, QR_Flaeche, QR_Versatz, QR_Text"
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.MoveFirst
        rst.Edit
        rst!QR_JaNein = True            ' true = QR-Code auf der Rechnung anzeigen
        rst!QR_Position = "R"           ' "L" links; "M" mittig; "R" rechts (Standard)
        rst!QR_Zoom = 0                 ' 0 = Standardgre des QR-Codes (ca. BxH = 35x33 mm Rahmengre!)
                                        ' sonst: -5,-4,..,0,..,+4,+5 fr kleiner oder grer
                                        ' eine Stufe entspricht 5% kleiner oder grer,
                                        ' d.h. bei +5 ist der QR-Code-Rahmen 25% grer als die Standardgre
        rst!QR_Flaeche = 89             ' 89 (ausprobierter Standardwert) bedeutet, dass der
                                        ' QR-Code 89 Prozent der Flche der beschrifteten Umrandung
                                        ' ausfllt (darber wird der Abstand zur Umrandung gesteuert)
        rst!QR_Versatz = 0.01           ' darber erfolgt die Feinjustierung des QR-Codes in der
                                        ' Umrandung (von oben links)
                                        ' 0.01 = (ausprobierter Standardwert) bedeutet, dass der QR-Code
                                        ' um 1% seiner Flche nach rechts und nach unten in den Rahmen
                                        ' hinein verschoben wird (zu dessen Mittelpunkt)
        rst!QR_Text = "Re. [ReNr] vom [ReDatum], [Name1]"   ' Buchungstext der berweisung, der nach dem Scannen in der
                                                            ' Banking-App vorgeschlagen wird
        rst.Update
        rst.Close
        
        
        
Fuellen_Version_20190317:
        'Db-Version [2019-03-17]
        '-----------------------
        On Error GoTo Error_FelderFuellen
        
        'Dummy fr Kategorien (wieder) anlegen
        'Korrektur eines Fehlers beim Lschen nicht benutzter Kategorien bei Outlook-bernahme
        FehlerTabelle = "Kategorien"
        FehlerFeld = "<Tabelle ffnen>"
        Zeichenkette = "SELECT * FROM Kategorien WHERE ([Kategorie_ID] = '0123456789DUMMY9876543210')"
        Set rst = dbs.OpenRecordset(Zeichenkette)
        If rst.RecordCount = 0 Then
            FehlerFeld = "Kategorie_ID, Name, FarbNr, Rot, Gruen, Blau"
            rst.AddNew
            rst!Kategorie_ID = "0123456789DUMMY9876543210"
            rst!Name1 = "(ohne Kategorie)"
            rst!FarbNr = 9999                   'wird hoffentlich nie von MS vergeben
            rst!Rot = 255                       ' R,G,B = 255 = wei
            rst!Gruen = 255
            rst!Blau = 255
            rst.Update
        End If
        rst.Close
        
        AnzeigeAktualisieren
        
        
        
        
        
        
        
        
        
        
        
        
        

        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
    End If
        
        
        
        
    'ganz zum Schluss:
    'ACHTUNG: Neue Versionsnummer eintragen!!!
    '-----------------------------------------
    If (Me.DatenkKonvertieren.Value = True) Or (Me.VersionAnpassen.Value = True) Then
        On Error GoTo Error_NeueVersionsNummer
        Set rst = dbs.OpenRecordset("Einstellungen")
        rst.Edit
        rst!DatenbankVersion = VersionDatenbank
        rst.Update
        rst.Close
    End If
    
    
    
    
    'Aktuellen Pfad merken
    On Error GoTo Error_PfadMerken
    Set rst = dbs.OpenRecordset("Datenbankpfad")
    rst.Edit
    rst!Quelle = Trim(Me.Pfadeingabe)
    rst.Update
    rst.Close
    
    'Zuordnung protokollieren
    On Error GoTo Error_ProtokollFehler
    Set rst = dbs.OpenRecordset("Datenbankzuordnungen")
    rst.AddNew
    rst!Datum = Now()
    rst!VersionDatenbank = VersionDatenbank
    If (Me.DatenkKonvertieren.Value = True) Or (Me.VersionAnpassen.Value = True) Then
        rst!VersionDatenbank = VersionDatenbank & " Anp!"
    End If
    rst!VersionProgramm = VersionProgramm
    rst!Pfad = Trim(Me.Pfadeingabe)
    rst.Update
    rst.Close
    
    Set dbs = Nothing
    
    
    Me.Hinweis.Caption = "Tabellen wurden neu verknpft."
    Me.Repaint
    
    'Meldung ber neue Datenbank
    If Me.DatenkKonvertieren.Value = True Then
        Zeichenkette = "Die Datendatei wurde in ein aktuelles Datenbankformat konvertiert." & vbNewLine & _
            "Sie trgt den Dateinamen:" & vbNewLine & vbNewLine & sFilename
            If i > 0 Then Zeichenkette = Zeichenkette & "_" & i
            Zeichenkette = Zeichenkette & ".accdb" & vbNewLine & vbNewLine & _
            "Bitte notieren Sie sich den Dateinamen und arbeiten Sie knftig mit dieser Datei." & vbNewLine & _
            "Sie finden den Dateinamen auch in der Terminabrechnung unter 'Auswertungen', 'Datenbankzuordnungen'."
        MsgBox Zeichenkette, vbInformation + vbOKOnly, "Neue Datendatei!"
    End If
    
    DoCmd.Close acForm, "Datenbankpfad_eingeben", acSaveNo
    
    
    'Heinweis auf wichtige Update-Informationen anzeigen
    If Len(WichtigeInfoZumUpdate) > 0 Then
        MsgBox WichtigeInfoZumUpdate, vbExclamation + vbOKOnly, "Updatehinweis"
    End If
    
    
    DoCmd.OpenForm "Hauptmenue"
    
    
Exit_Button_Uebernehmen_Click:
    Exit Sub
    
    
Error_ExklusivOeffnen:
    Me.Hinweis.Caption = Meldungstext
    Me.Repaint
    Me.Abbruch.Enabled = True
    Me.Abbruch.SetFocus
    Zeichenkette = "Die ausgewhlte Datenbank konnte nicht exklusiv geffnet werden!" & vbNewLine & vbNewLine & _
        "Bitte stellen Sie sicher, dass die Datei von keinem anderen Benutzer geffnet ist und versuchen Sie es dann erneut." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description
    MsgBox Zeichenkette, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_Button_Uebernehmen_Click
    
Error_TabellenVerknuepfen:
    Me.Hinweis.Caption = "Fehler beim Verbinden mit der Datendatei!"
    Me.Repaint
    Me.Abbruch.Enabled = True
    Me.Abbruch.SetFocus
    Me.Button_Uebernehmen.Enabled = False
    Zeichenkette = "Bei dem Versuch, die Tabelle [" & FehlerTabelle & "] der Datendatei neu zu verknpfen, " & _
        "ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description
    MsgBox Zeichenkette, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_Button_Uebernehmen_Click
    
Error_NeueVersionsNummer:
    Me.Hinweis.Caption = "Fehler beim Speichern der neuen Versionsnummer!"
    Me.Repaint
    Me.Abbruch.Enabled = True
    Me.Abbruch.SetFocus
    Zeichenkette = "Bei dem Versuch, die neue Versionsnummer in die Datenbank zu schreiben, ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description
    MsgBox Zeichenkette, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_Button_Uebernehmen_Click
    
Error_PfadMerken:
    Me.Hinweis.Caption = "Fehler beim Speichern des Namens der Datendatei!"
    Me.Repaint
    Me.Abbruch.Enabled = True
    Me.Abbruch.SetFocus
    Zeichenkette = "Bei dem Versuch, den aktuellen Dateipfad in der Datendatei zu vermerken, ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description
    MsgBox Zeichenkette, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_Button_Uebernehmen_Click
    
Error_ProtokollFehler:
    Me.Hinweis.Caption = "Fehler beim Protokollieren der Datenbankanpassung!"
    Me.Repaint
    Me.Abbruch.Enabled = True
    Me.Abbruch.SetFocus
    Zeichenkette = "Bei dem Versuch, den Protokolleintrag fr die Datenbankanpassung zu erstellen, ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description
    MsgBox Zeichenkette, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_Button_Uebernehmen_Click

Error_FelderAnfuegen:
    Me.Hinweis.Caption = "Fehler beim Erweitern der Tabellenstruktur!"
    Me.Repaint
    Me.Abbruch.Enabled = True
    Me.Abbruch.SetFocus
    Me.Button_Uebernehmen.Enabled = False
    Zeichenkette = "Bei dem Versuch, die Tabelle [" & FehlerTabelle & "] um das Datenfeld [" & FehlerFeld & "] zu erweitern, " & _
        "ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description
    MsgBox Zeichenkette, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_Button_Uebernehmen_Click
    
Error_FelderFuellen:
    Me.Hinweis.Caption = "Fehler beim Fllen der neuen Datenfelder!"
    Me.Repaint
    Me.Abbruch.Enabled = True
    Me.Abbruch.SetFocus
    Me.Button_Uebernehmen.Enabled = False
    Zeichenkette = "Bei dem Versuch, in der Tabelle [" & FehlerTabelle & "] das neue Datenfeld [" & FehlerFeld & "] mit einem Standardwert zu fllen, " & _
        "ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description
    MsgBox Zeichenkette, vbCritical + vbOKOnly, "Fehler"
    Resume Exit_Button_Uebernehmen_Click
    
End Sub

Private Sub Pfadeingabe_Exit(Cancel As Integer)
    'Eingabelnge auf 250 Zeichen begrenzen
    Me.Pfadeingabe = Trim(Left(Trim(Me.Pfadeingabe), 250))
End Sub

Private Sub Befehl13_Click()
On Error GoTo Err_Befehl13_Click

    Dim Pfad, AktVerzeichnis As String
    
    AktVerzeichnis = Left(CurrentDb.Name, Len(CurrentDb.Name) - Len(Dir(CurrentDb.Name)))
    Pfad = DateiOeffnen(AktVerzeichnis, "Datei ffnen")
    
    If Len(Pfad) > 1 Then
        Me.Pfadeingabe.Value = Pfad
    End If
    
    Me.Pfadeingabe.SetFocus
    Me.Pfadeingabe.SelStart = 500       'Cursor ans Ende setzen
    
    
Exit_Befehl13_Click:
    Exit Sub

Err_Befehl13_Click:
    MsgBox err.Description
    Resume Exit_Befehl13_Click
    
End Sub
